/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;

public class MenuItem extends Item {
	Menu parent, menu;

public MenuItem (Menu parent, int style) {
	this (parent, style, -1);
}

public MenuItem (Menu parent, int style, int index) {
	super (parent, style, index);
	this.parent=parent;
}

public void addArmListener (ArmListener listener) {
}

public void addHelpListener (HelpListener listener) {
}

public void addSelectionListener (SelectionListener listener) {
	checkWidget ();
	if (listener == null) error (SWT.ERROR_NULL_ARGUMENT);
	TypedListener typedListener = new TypedListener (listener);
	addListener (SWT.Selection,typedListener);
	addListener (SWT.DefaultSelection,typedListener);
}

protected void checkSubclass () {
}

void createWidget(Display display, Widget parent, int style, int index) {
	super.createWidget(display, parent, style, index);
	this.parent = (Menu) parent;
	int newIndex = index;
	if (index==-1) { newIndex = this.parent.getItemCount(); }
	this.parent.createItem (parent, this, style, newIndex);
	hookEvents ();
	register ();
	text = "";
}

public int getAccelerator () {
	return 0;
}

public boolean getEnabled () {
	return false;
}

public Menu getMenu () {
	return null;
}

public Menu getParent () {
	return null;
}

public boolean getSelection () {
	return false;
}

void hookEvents () {
	_hookEvents("onmousedown", 	SWT.MouseDown);
	_hookEvents("onfocus", 		SWT.FocusIn);
	_hookEvents("onblur", 		SWT.FocusOut);
}

public boolean isEnabled () {
	return false;
}

public void removeArmListener (ArmListener listener) {
}

public void removeHelpListener (HelpListener listener) {
}

public void removeSelectionListener (SelectionListener listener) {
}

public void setAccelerator (int accelerator) {
}

public void setEnabled (boolean enabled) {
}

public void setImage (Image image) {
}

public void setMenu (Menu menu) {
	_setMenu (menu);
}

public void setSelection (boolean selected) {
}

public void setText (String string) {
	super.setText(string);
	_setText(string);
}

/*---------------- NATIVE INTERFACE ----------------*/

protected native void _createItem (Widget parent, int style, int index) /*-{
	if((style & (@org.eclipse.swt.SWT::CHECK | @org.eclipse.swt.SWT::PUSH | @org.eclipse.swt.SWT::RADIO | @org.eclipse.swt.SWT::SEPARATOR)) != 0){
		if(!$wnd.dojo._hasResource["org.eclipse.swt.MenuItem"]){
			$wnd.dojo._hasResource["org.eclipse.swt.MenuItem"] = true;
			$wnd.dojo.provide("org.eclipse.swt.MenuItem");
			
			$wnd.dojo.declare("org.eclipse.swt.MenuItem", $wnd.dijit.MenuItem, {
				setLabel: function(label){
					this.containerNode.innerHTML=this.label=label;
				}
			});
		}
	}
	if((style & (@org.eclipse.swt.SWT::SEPARATOR)) != 0){
		if(!$wnd.dojo._hasResource["org.eclipse.swt.MenuItemSeparator"]){
			$wnd.dojo._hasResource["org.eclipse.swt.MenuItemSeparator"] = true;
			$wnd.dojo.provide("org.eclipse.swt.MenuItemSeparator");
			
			$wnd.dojo.declare("org.eclipse.swt.MenuItemSeparator", $wnd.dijit.MenuSeparator, {
				setLabel: function(label){
					this.containerNode.innerHTML=this.label=label;
				}
			});
		}
	}
	if((style & (@org.eclipse.swt.SWT::CASCADE)) != 0){
		if(!$wnd.dojo._hasResource["org.eclipse.swt.PopupMenuItem"]){
			$wnd.dojo._hasResource["org.eclipse.swt.PopupMenuItem"] = true;
			$wnd.dojo.provide("org.eclipse.swt.PopupMenuItem");
			
			$wnd.dojo.declare("org.eclipse.swt.PopupMenuItem", $wnd.dijit.PopupMenuItem, {
				postCreate: function(){
					$wnd.dojo.addClass(this.expand, "dijitMenuExpandEnabled");
					$wnd.dojo.style(this.expand, "display", "");
					this.inherited("postCreate",arguments);
				},
				setLabel: function(label){
					this.containerNode.innerHTML=this.label=label;
				}
			});
		}
	}
	
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	var params = {};
	if((style & (@org.eclipse.swt.SWT::CHECK | @org.eclipse.swt.SWT::PUSH | @org.eclipse.swt.SWT::RADIO)) != 0){
		var self = new $wnd.org.eclipse.swt.MenuItem(params);
	} else if((style & (@org.eclipse.swt.SWT::SEPARATOR)) != 0){
		var self = new $wnd.org.eclipse.swt.MenuItemSeparator(params);
	} else if((style & (@org.eclipse.swt.SWT::CASCADE)) != 0) {
		params.popup = jsParent;
		var self = new $wnd.org.eclipse.swt.PopupMenuItem(params);
	}
	try {
		this.@org.eclipse.swt.widgets.Widget::jsObject = self;
		jsParent.addChild(self);
	} catch (e) {
//TODO Have to throw real exception for Java side also	
		$wnd.console.log(e);
	}
}-*/;

native void _setMenu (Menu menu) /*-{
	this.@org.eclipse.swt.widgets.Widget::jsObject.popup = menu.@org.eclipse.swt.widgets.Widget::jsObject;
}-*/;

native void _setText (String string) /*-{
	this.@org.eclipse.swt.widgets.Widget::jsObject.setLabel(string);
}-*/;

}
